/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.coremods;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.neoforged.neoforge.coremods.NeoForgeCoreMod;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

final class CoremodUtils {
    private static final Gson GSON = new Gson();

    CoremodUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T loadResource(String filename, TypeToken<T> type) {
        InputStream stream = NeoForgeCoreMod.class.getResourceAsStream(filename);
        if (stream == null) {
            throw new IllegalStateException("Missing resource: " + filename);
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Object object = GSON.fromJson((Reader)reader, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read JSON resource " + filename);
        }
    }

    static <T> T loadResource(String filename, Class<T> type) {
        return CoremodUtils.loadResource(filename, TypeToken.get(type));
    }

    static FieldNode getFieldByName(ClassNode classNode, String fieldName) {
        FieldNode foundField = null;
        for (FieldNode fieldNode : classNode.fields) {
            if (!Objects.equals(fieldNode.name, fieldName)) continue;
            if (foundField == null) {
                foundField = fieldNode;
                continue;
            }
            throw new IllegalStateException("Found multiple fields with name " + fieldName + " in " + classNode.name);
        }
        if (foundField == null) {
            throw new IllegalStateException("No field with name " + fieldName + " found in class " + classNode.name);
        }
        return foundField;
    }

    static MethodNode getMethodByDescriptor(ClassNode classNode, @Nullable String methodName, String methodSignature) {
        MethodNode foundMethod = null;
        for (MethodNode methodNode : classNode.methods) {
            if (!Objects.equals(methodNode.desc, methodSignature) || methodName != null && !Objects.equals(methodNode.name, methodName)) continue;
            if (foundMethod == null) {
                foundMethod = methodNode;
                continue;
            }
            throw new IllegalStateException("Found duplicate method with signature " + methodSignature + " in " + classNode.name);
        }
        if (foundMethod == null) {
            if (methodName != null) {
                throw new IllegalStateException("Unable to find method " + methodSignature + " with name " + methodName + " in " + classNode.name);
            }
            throw new IllegalStateException("Unable to find method " + methodSignature + " in " + classNode.name);
        }
        return foundMethod;
    }
}

